/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ViewOriginScreen
extends Screen {
    private static final ResourceLocation WINDOW = new ResourceLocation("origins", "textures/gui/choose_origin.png");
    private ArrayList<Tuple<OriginLayer, Origin>> originLayers;
    private int currentLayer = 0;
    private static final int windowWidth = 176;
    private static final int windowHeight = 182;
    private int scrollPos = 0;
    private int currentMaxScroll = 0;
    private int border = 13;
    private Button chooseOriginButton;
    private int guiTop;
    private int guiLeft;

    public ViewOriginScreen() {
        super((ITextComponent)new TranslationTextComponent("origins.screen.view_origin"));
        HashMap<OriginLayer, Origin> origins = ModComponentsArchitectury.getOriginComponent((Entity)Minecraft.func_71410_x().field_71439_g).getOrigins();
        this.originLayers = new ArrayList(origins.size());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        origins.forEach((arg_0, arg_1) -> this.lambda$new$0((PlayerEntity)player, arg_0, arg_1));
        this.originLayers.sort(Comparator.comparing(Tuple::func_76341_a));
    }

    public boolean func_231178_ax__() {
        return true;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - 176) / 2;
        this.guiTop = (this.field_230709_l_ - 182) / 2;
        if (this.originLayers.size() > 0) {
            this.chooseOriginButton = new Button(this.guiLeft + 88 - 50, this.guiTop + 182 - 40, 100, 20, (ITextComponent)new TranslationTextComponent("origins.gui.choose"), b -> Minecraft.func_71410_x().func_147108_a((Screen)new ChooseOriginScreen(Lists.newArrayList((Object[])new OriginLayer[]{(OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()}), 0, false)));
            this.func_230480_a_((Widget)this.chooseOriginButton);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            this.chooseOriginButton.field_230694_p_ = this.originLayers.get(this.currentLayer).func_76340_b() == Origin.EMPTY && ((OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()).getOriginOptionCount((PlayerEntity)player) > 0;
            this.chooseOriginButton.field_230693_o_ = this.chooseOriginButton.field_230694_p_;
            this.func_230480_a_((Widget)new Button(this.guiLeft - 40, this.field_230709_l_ / 2 - 10, 20, 20, (ITextComponent)new StringTextComponent("<"), arg_0 -> this.lambda$init$2((PlayerEntity)player, arg_0)));
            this.func_230480_a_((Widget)new Button(this.guiLeft + 176 + 20, this.field_230709_l_ / 2 - 10, 20, 20, (ITextComponent)new StringTextComponent(">"), arg_0 -> this.lambda$init$3((PlayerEntity)player, arg_0)));
        }
        this.func_230480_a_((Widget)new Button(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (ITextComponent)new TranslationTextComponent("origins.gui.close"), b -> Minecraft.func_71410_x().func_147108_a(null)));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private void renderOriginWindow(MatrixStack matrices, int mouseX, int mouseY) {
        boolean hasLayer;
        RenderSystem.enableBlend();
        boolean bl = hasLayer = this.originLayers.size() > 0;
        if (hasLayer && OriginsClient.isServerRunningOrigins) {
            this.renderWindowBackground(matrices, 16, 0);
            this.renderOriginContent(matrices, mouseX, mouseY);
            this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
            this.func_238474_b_(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
            this.renderOriginName(matrices);
            this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
            this.renderOriginImpact(matrices, mouseX, mouseY);
            TranslationTextComponent title = new TranslationTextComponent("origins.gui.view_origin.title", new Object[]{new TranslationTextComponent(((OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()).getTranslationKey())});
            ViewOriginScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)title.getString(), (int)(this.field_230708_k_ / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        } else if (OriginsClient.isServerRunningOrigins) {
            ViewOriginScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)new TranslationTextComponent("origins.gui.view_origin.empty").getString(), (int)(this.field_230708_k_ / 2), (int)(this.guiTop + 15), (int)0xFFFFFF);
        } else {
            ViewOriginScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)new TranslationTextComponent("origins.gui.view_origin.not_installed").getString(), (int)(this.field_230708_k_ / 2), (int)(this.guiTop + 15), (int)0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private Origin getCurrentOrigin() {
        return (Origin)this.originLayers.get(this.currentLayer).func_76340_b();
    }

    private void renderOriginImpact(MatrixStack matrices, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.func_238474_b_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.func_238474_b_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            TranslationTextComponent ttc = (TranslationTextComponent)new TranslationTextComponent("origins.gui.impact.impact").func_240702_b_(": ").func_230529_a_((ITextComponent)impact.getTextComponent());
            this.func_238652_a_(matrices, (ITextComponent)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(MatrixStack matrices) {
        Origin origin = this.getCurrentOrigin();
        ITextProperties originName = this.field_230712_o_.func_238417_a_((ITextProperties)(origin == Origin.EMPTY ? new TranslationTextComponent(((OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()).getMissingOriginNameTranslationKey()) : origin.getName()), 140);
        ViewOriginScreen.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        ItemStack is = origin.getDisplayItem();
        this.field_230707_j_.func_239390_c_(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(MatrixStack matrices, int offsetYStart, int offsetYEnd) {
        int endX = this.guiLeft + 176 - this.border;
        int endY = this.guiTop + 182 - this.border;
        this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.func_238474_b_(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean func_231043_a_(double x, double y, double z) {
        boolean retValue = super.func_231043_a_(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(MatrixStack matrices, int mouseX, int mouseY) {
        int y;
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        Origin origin = this.getCurrentOrigin();
        TranslationTextComponent orgDesc = origin.getDescription();
        if (origin == Origin.EMPTY) {
            orgDesc = new TranslationTextComponent(((OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()).getMissingOriginDescriptionTranslationKey());
        }
        List descLines = this.field_230712_o_.func_238425_b_((ITextProperties)orgDesc, 140);
        for (IReorderingProcessor iReorderingProcessor : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.field_230712_o_.func_238422_b_(matrices, iReorderingProcessor, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (origin == Origin.EMPTY) {
            return;
        }
        for (PowerType powerType : origin.getPowerTypes()) {
            if (powerType.isHidden()) continue;
            IReorderingProcessor name = LanguageMap.func_74808_a().func_241870_a(this.field_230712_o_.func_238417_a_((ITextProperties)powerType.getName().func_240699_a_(TextFormatting.UNDERLINE), 140));
            TranslationTextComponent desc = powerType.getDescription();
            List drawLines = this.field_230712_o_.func_238425_b_((ITextProperties)desc, 140);
            if (y >= startY - 24 && y <= endY + 12) {
                this.field_230712_o_.func_238422_b_(matrices, name, (float)x, (float)y, 0xFFFFFF);
            }
            for (IReorderingProcessor line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.field_230712_o_.func_238422_b_(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        }
        this.currentMaxScroll = (y += this.scrollPos) - 182 - 15;
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private /* synthetic */ void lambda$init$3(PlayerEntity player, Button b) {
        this.currentLayer = (this.currentLayer + 1) % this.originLayers.size();
        this.chooseOriginButton.field_230694_p_ = this.originLayers.get(this.currentLayer).func_76340_b() == Origin.EMPTY && ((OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()).getOriginOptionCount(player) > 0;
        this.chooseOriginButton.field_230693_o_ = this.chooseOriginButton.field_230694_p_;
        this.scrollPos = 0;
    }

    private /* synthetic */ void lambda$init$2(PlayerEntity player, Button b) {
        this.currentLayer = (this.currentLayer - 1 + this.originLayers.size()) % this.originLayers.size();
        this.chooseOriginButton.field_230694_p_ = this.originLayers.get(this.currentLayer).func_76340_b() == Origin.EMPTY && ((OriginLayer)this.originLayers.get(this.currentLayer).func_76341_a()).getOriginOptionCount(player) > 0;
        this.chooseOriginButton.field_230693_o_ = this.chooseOriginButton.field_230694_p_;
        this.scrollPos = 0;
    }

    private /* synthetic */ void lambda$new$0(PlayerEntity player, OriginLayer layer, Origin origin) {
        if (origin.getDisplayItem().func_77973_b() == Items.field_196184_dx) {
            origin.getDisplayItem().func_196082_o().func_74778_a("SkullOwner", player.func_145748_c_().getString());
        }
        if (origin != Origin.EMPTY || layer.getOriginOptionCount(player) > 0) {
            this.originLayers.add((Tuple<OriginLayer, Origin>)new Tuple((Object)layer, (Object)origin));
        }
    }
}

